/**
 * BasicHTTPClient.ino
 *
 *  Created on: 24.05.2015
 *
 */

#include <Arduino.h>

#include <WiFi.h>
#include <WiFiMulti.h>

#include <HTTPClient.h>

#define USE_SERIAL Serial

WiFiMulti wifiMulti;
const int buzzerPin = 4;


int pirPin = 12; // PIR sensor output pin
int  lastpirstate = LOW; 
int buzzerState = LOW; 
unsigned long lastpirtime = 0; 
unsigned long pirInterval = 10000; 
void setup() {
    pinMode(14,OUTPUT); 
    USE_SERIAL.begin(115200);

    USE_SERIAL.println();
    USE_SERIAL.println();
    USE_SERIAL.println();
    pinMode(pirPin, INPUT);

    for(uint8_t t = 4; t > 0; t--) {
        USE_SERIAL.printf("[SETUP] WAIT %d...\n", t);
        USE_SERIAL.flush();
        delay(1000);
    }

    wifiMulti.addAP("iPhone (4)", "123456789");
}

void loop() {
    // wait for WiFi connection
    int pinstate = digitalRead(pirPin); 
    if((wifiMulti.run() == WL_CONNECTED)) {
      if(pinstate == HIGH && lastpirstate == LOW && (millis() - lastpirtime > pirInterval)){
        USE_SERIAL.print("Motion-Detected \n");
        lastpirtime = millis(); 
        HTTPClient http;
        // configure traged server and url

        http.begin("https://web.engr.oregonstate.edu/~osmanf/motioncamera.php?motion-detected=true"); //HTTP

        USE_SERIAL.print("[HTTP] GET...\n");
        // start connection and send HTTP header
        int httpCode = http.GET();

        // httpCode will be negative on error
        if(httpCode > 0) {
            // HTTP header has been send and Server response header has been handled
            USE_SERIAL.printf("[HTTP] GET... code: %d\n",
            httpCode);

            // file found at server
            if(httpCode == HTTP_CODE_OK) {
                String payload = http.getString();
                USE_SERIAL.println(payload);
            }
        }
         else {
            USE_SERIAL.printf("[HTTP] GET... failed, error: %s\n", http.errorToString(httpCode).c_str());
        }
         http.end();
         analogWrite(14, 20);  
         buzzerState = HIGH; 
    }
   
    else {
      USE_SERIAL.printf("No motion detected \n");
      HTTPClient http;
       http.begin("https://web.engr.oregonstate.edu/~osmanf/motioncamera.php?nomotion-detected=true"); //HTTP

        USE_SERIAL.print("[HTTP] GET...\n");
        // start connection and send HTTP header
        int httpCode = http.GET();

        // httpCode will be negative on error
        if(httpCode > 0) {
            // HTTP header has been send and Server response header has been handled
            USE_SERIAL.printf("[HTTP] GET... code: %d\n",
            httpCode);

            // file found at server
            if(httpCode == HTTP_CODE_OK) {
                String payload = http.getString();
                USE_SERIAL.println(payload);
            }
        }
         else {
            USE_SERIAL.printf("[HTTP] GET... failed, error: %s\n", http.errorToString(httpCode).c_str());
        }
         http.end();
    }
       
    }
    if(buzzerState = HIGH){
      delay(5000); 
      analogWrite(14, 0); 
      buzzerState = LOW; 
    }
    lastpirstate = pinstate; 
    delay(5000);
}

    
