#include <ArduinoJson.h>
#include <SPI.h>
#include <RH_RF95.h>
#include <RHReliableDatagram.h>
#include <RH_Serial.h>// prob not needed 

// transmitter code send a json file 
// receiver sned a differnt json file but same idea 

#define ADDRESS 0
#define ADDRESS_SEND 1 // make sure it is opp of the tranmitter code 

/* for feather32u4 
#define RFM95_CS 8
#define RFM95_RST 4
#define RFM95_INT 7
*/
#define MAX_MESSAGE_LEN 255
 //for feather m0  
#define RFM95_CS 8
#define RFM95_RST 4
#define RFM95_INT 3

#define ADDRESS 1
#define ADDRESS_SEND 0
#define MAX_WAIT 100

#define retry_count 5
#define retry_timeout 200


/* for Feather32u4 RFM9x
#define RFM95_CS 8
#define RFM95_RST 4
#define RFM95_INT 7
*/

// for feather m0 RFM9x
#define RFM95_CS 8
#define RFM95_RST 4
#define RFM95_INT 3


/* for shield 
#define RFM95_CS 10
#define RFM95_RST 9
#define RFM95_INT 7
*/

/* Feather 32u4 w/wing
#define RFM95_RST     11   // "A"
#define RFM95_CS      10   // "B"
#define RFM95_INT     2    // "SDA" (only SDA/SCL/RX/TX have IRQ!)
*/

/* Feather m0 w/wing 
#define RFM95_RST     11   // "A"
#define RFM95_CS      10   // "B"
#define RFM95_INT     6    // "D"
*/

#if defined(ESP8266)
  /* for ESP w/featherwing */ 
  #define RFM95_CS  2    // "E"
  #define RFM95_RST 16   // "D"
  #define RFM95_INT 15   // "B"

#elif defined(ARDUINO_ADAFRUIT_FEATHER_ESP32S2)
  #define RFM95_INT     9  // "A"
  #define RFM95_CS      10  // "B"
  #define RFM95_RST     11  // "C"
  #define LED       

#elif defined(ESP32)  
  /* ESP32 feather w/wing */
  #define RFM95_RST     27   // "A"
  #define RFM95_CS      33   // "B"
  #define RFM95_INT     12   //  next to A

#elif defined(NRF52)  
  /* nRF52832 feather w/wing */
  #define RFM95_RST     7   // "A"
  #define RFM95_CS      11   // "B"
  #define RFM95_INT     31   // "C"
  
#elif defined(TEENSYDUINO)
  /* Teensy 3.x w/wing */
  #define RFM95_RST     9   // "A"
  #define RFM95_CS      10   // "B"
  #define RFM95_INT     4    // "C"
#endif


// Change to 434.0 or other frequency, must match RX's freq!
#define RF95_FREQ 915.0

// Singleton instance of the radio driver

// Blinky on receipt
#define LED 13
RH_RF95 driver(RFM95_CS, RFM95_INT);
RHReliableDatagram manager(driver, ADDRESS);
void setup()
{
  pinMode(LED, OUTPUT);
  pinMode(RFM95_RST, OUTPUT);
  digitalWrite(RFM95_RST, HIGH);

  Serial.begin(115200);
  while (!Serial) {
    delay(1);
  }
  delay(100);

  Serial.println("Feather LoRa RX Test!");

  bool status;
   status = manager.init();
  Serial.println("initializing manager"); 
  Serial.println((status)? " Success" : "Failed");


  status = driver.setFrequency(RF95_FREQ);
  Serial.println("setting Frequency");
  Serial.println((status)? " Success" : "Failed");

  Serial.println("setting power level to 23 " );
  driver.setTxPower(23, false);// maybe define 23 wtih power level 

  Serial.print( " setting retty timeout to"); 
  Serial.print( retry_timeout); 
  Serial.print(" ms");// make sure to define rety time out at top or somethjign  300 ms by default
  Serial.println(); 

 
  manager.setTimeout(retry_timeout); 

  Serial.print("settintg max retry coutn"); 
  Serial.print(retry_count);// make sure to define retry count to 3 my defualt 
  Serial.println(); 
  manager.setRetries(retry_count); 
  
//  driver.setModemConfig(RH_RF95::Bw500Cr45Sf128);
//  driver.sleep();// fore saving opwer \
  
  // manual reset
  digitalWrite(RFM95_RST, LOW);
  delay(10);
  digitalWrite(RFM95_RST, HIGH);
  delay(10);
}

void loop()
{

  char  buffer[MAX_MESSAGE_LEN]; 
  uint8_t len = sizeof(buffer); 
  uint8_t from; 
 if (manager.recvfromAckTimeout((uint8_t*)buffer, &len, MAX_WAIT, &from)){
    Serial.println("Got request from : 0x");
    Serial.print(from);
    Serial.print(": ");
    Serial.println((char*)buffer);
    Serial.println();
  }
}
