/*
  defaults.h - defaults settings configuration file

  Do NOT modify this file unless adding settings!
  Changes to these default values should be made in config.h or by declaring compiler symbols.

  NOTE: This file is only used by settings.c and should NOT be referenced elsewhere!

  Part of grblHAL

  Copyright (c) 2017-2020 Terje Io
  Copyright (c) 2012-2016 Sungeun K. Jeon for Gnea Research LLC

  Grbl is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Grbl is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Grbl.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _DEFAULTS_H_
#define _DEFAULTS_H_

#include "config.h"

#ifndef BUILD_INFO
#define BUILD_INFO ""
#endif

// Note: DEFAULT_ACCELERATION is only referenced in this file
#define DEFAULT_ACCELERATION (10.0f * 60.0f * 60.0f) // 10*60*60 mm/min^2 = 10 mm/sec^2

#ifndef DISABLE_G92_PERSISTENCE
#if COMPATIBILITY_LEVEL <= 1
#define DISABLE_G92_PERSISTENCE 0
#else
#define DISABLE_G92_PERSISTENCE 1
#endif
#endif

#ifdef DEFAULT_REPORT_MACHINE_POSITION
#undef DEFAULT_REPORT_MACHINE_POSITION
#define DEFAULT_REPORT_MACHINE_POSITION 1
#else
#define DEFAULT_REPORT_MACHINE_POSITION 0
#endif

#ifdef DEFAULT_NO_REPORT_BUFFER_STATE
#undef DEFAULT_NO_REPORT_BUFFER_STATE
#define DEFAULT_REPORT_BUFFER_STATE 0
#else
#define DEFAULT_REPORT_BUFFER_STATE 1
#endif

#ifdef DEFAULT_NO_REPORT_LINE_NUMBERS
#undef DEFAULT_NO_REPORT_LINE_NUMBERS
#define DEFAULT_REPORT_LINE_NUMBERS 0
#else
#define DEFAULT_REPORT_LINE_NUMBERS 1
#endif

#ifdef DEFAULT_NO_REPORT_CURRENT_FEED_SPEED
#undef DEFAULT_NO_REPORT_CURRENT_FEED_SPEED
#define DEFAULT_REPORT_CURRENT_FEED_SPEED 0
#else
#define DEFAULT_REPORT_CURRENT_FEED_SPEED 1
#endif

#ifdef DEFAULT_NO_REPORT_PIN_STATE
#undef DEFAULT_NO_REPORT_PIN_STATE
#define DEFAULT_REPORT_PIN_STATE 0
#else
#define DEFAULT_REPORT_PIN_STATE 1
#endif

#ifdef DEFAULT_NO_REPORT_WORK_COORD_OFFSET
#undef DEFAULT_NO_REPORT_WORK_COORD_OFFSET
#define DEFAULT_REPORT_WORK_COORD_OFFSET 0
#else
#define DEFAULT_REPORT_WORK_COORD_OFFSET 1
#endif

#ifdef DEFAULT_NO_REPORT_OVERRIDES
#undef DEFAULT_NO_REPORT_OVERRIDES
#define DEFAULT_REPORT_OVERRIDES 0
#else
#define DEFAULT_REPORT_OVERRIDES 1
#endif

#ifdef DEFAULT_NO_REPORT_PROBE_COORDINATES
#undef DEFAULT_NO_REPORT_PROBE_COORDINATES
#define DEFAULT_REPORT_PROBE_COORDINATES 0
#else
#define DEFAULT_REPORT_PROBE_COORDINATES 1
#endif

#ifdef DEFAULT_NO_FORCE_BUFFER_SYNC_DURING_WCO_CHANGE
#undef DEFAULT_NO_FORCE_BUFFER_SYNC_DURING_WCO_CHANGE
#define DEFAULT_REPORT_SYNC_ON_WCO_CHANGE 0
#else
#define DEFAULT_REPORT_SYNC_ON_WCO_CHANGE 1
#endif

#ifdef DEFAULT_REPORT_PARSER_STATE
#undef DEFAULT_REPORT_PARSER_STATE
#define DEFAULT_REPORT_PARSER_STATE 1
#else
#define DEFAULT_REPORT_PARSER_STATE 0
#endif

#ifdef DEFAULT_REPORT_ALARM_SUBSTATE
#undef DEFAULT_REPORT_ALARM_SUBSTATE
#define DEFAULT_REPORT_ALARM_SUBSTATE 1
#else
#define DEFAULT_REPORT_ALARM_SUBSTATE 0
#endif

#ifndef DEFAULT_X_STEPS_PER_MM
#define DEFAULT_X_STEPS_PER_MM 250.0f
#endif
#ifndef DEFAULT_Y_STEPS_PER_MM
#define DEFAULT_Y_STEPS_PER_MM 250.0f
#endif
#ifndef DEFAULT_Z_STEPS_PER_MM
#define DEFAULT_Z_STEPS_PER_MM 250.0f
#endif
#ifndef DEFAULT_X_MAX_RATE
#define DEFAULT_X_MAX_RATE 500.0f
#endif
#ifndef DEFAULT_Y_MAX_RATE
#define DEFAULT_Y_MAX_RATE 500.0f
#endif
#ifndef DEFAULT_Z_MAX_RATE
#define DEFAULT_Z_MAX_RATE 500.0f
#endif
#ifndef DEFAULT_X_ACCELERATION
#define DEFAULT_X_ACCELERATION DEFAULT_ACCELERATION
#endif
#ifndef DEFAULT_Y_ACCELERATION
#define DEFAULT_Y_ACCELERATION DEFAULT_ACCELERATION
#endif
#ifndef DEFAULT_Z_ACCELERATION
#define DEFAULT_Z_ACCELERATION DEFAULT_ACCELERATION
#endif
#ifndef DEFAULT_X_MAX_TRAVEL
#define DEFAULT_X_MAX_TRAVEL 200.0f
#endif
#ifndef DEFAULT_Y_MAX_TRAVEL
#define DEFAULT_Y_MAX_TRAVEL 200.0f
#endif
#ifndef DEFAULT_Z_MAX_TRAVEL
#define DEFAULT_Z_MAX_TRAVEL 200.0f
#endif
#ifndef DEFAULT_X_CURRENT
#define DEFAULT_X_CURRENT 0.0
#endif
#ifndef DEFAULT_Y_CURRENT
#define DEFAULT_Y_CURRENT 0.0
#endif
#ifndef DEFAULT_Z_CURRENT
#define DEFAULT_Z_CURRENT 0.0
#endif
#ifndef DEFAULT_A_CURRENT
#define DEFAULT_A_CURRENT 0.0
#endif
#ifndef DEFAULT_SPINDLE_PWM_FREQ
#define DEFAULT_SPINDLE_PWM_FREQ 490
#endif
#ifndef DEFAULT_SPINDLE_PWM_OFF_VALUE
#define DEFAULT_SPINDLE_PWM_OFF_VALUE 0.0f
#endif
#ifndef DEFAULT_SPINDLE_PWM_MIN_VALUE
#define DEFAULT_SPINDLE_PWM_MIN_VALUE 0.0f
#endif
#ifndef DEFAULT_SPINDLE_PWM_MAX_VALUE
#define DEFAULT_SPINDLE_PWM_MAX_VALUE 255.0f
#endif
#ifndef DEFAULT_SPINDLE_AT_SPEED_TOLERANCE
#define DEFAULT_SPINDLE_AT_SPEED_TOLERANCE 0.0f
#endif
#ifndef DEFAULT_SPINDLE_RPM_MAX
#define DEFAULT_SPINDLE_RPM_MAX 1000.0
#endif
#ifndef DEFAULT_SPINDLE_RPM_MIN
#define DEFAULT_SPINDLE_RPM_MIN 0.0
#endif
#ifndef DEFAULT_SPINDLE_PWM_ACTION
#define DEFAULT_SPINDLE_PWM_ACTION 0
#endif
#ifndef DEFAULT_STEP_PULSE_MICROSECONDS
#define DEFAULT_STEP_PULSE_MICROSECONDS 10.0f
#endif
#ifndef DEFAULT_STEP_PULSE_DELAY
#define DEFAULT_STEP_PULSE_DELAY 0.0f
#endif
#ifndef DEFAULT_STEPPING_INVERT_MASK
#define DEFAULT_STEPPING_INVERT_MASK 0
#endif
#ifndef DEFAULT_DIRECTION_INVERT_MASK
#define DEFAULT_DIRECTION_INVERT_MASK 0
#endif
#ifndef DEFAULT_GANGED_DIRECTION_INVERT_MASK
#define DEFAULT_GANGED_DIRECTION_INVERT_MASK 0
#endif
#ifndef DEFAULT_STEPPER_IDLE_LOCK_TIME
#define DEFAULT_STEPPER_IDLE_LOCK_TIME 25
#endif
#ifndef DEFAULT_JUNCTION_DEVIATION
#define DEFAULT_JUNCTION_DEVIATION 0.01f
#endif
#ifndef DEFAULT_ARC_TOLERANCE
#define DEFAULT_ARC_TOLERANCE 0.002f
#endif

#ifdef DEFAULT_INVERT_LIMIT_BITS
#undef DEFAULT_INVERT_LIMIT_BITS
#define INVERT_LIMIT_BIT_MASK AXES_BITMASK
#endif

#ifdef DEFAULT_REPORT_INCHES
#undef DEFAULT_REPORT_INCHES
#define DEFAULT_REPORT_INCHES 1
#else
#define DEFAULT_REPORT_INCHES 0
#endif

#ifdef DEFAULT_SOFT_LIMIT_ENABLE
#undef DEFAULT_SOFT_LIMIT_ENABLE
#define DEFAULT_SOFT_LIMIT_ENABLE 1
#else
#define DEFAULT_SOFT_LIMIT_ENABLE 0
#endif

#ifdef DEFAULT_JOG_LIMIT_ENABLE
#undef DEFAULT_JOG_LIMIT_ENABLE
#define DEFAULT_JOG_LIMIT_ENABLE 1
#else
#define DEFAULT_JOG_LIMIT_ENABLE 0
#endif

#ifdef DEFAULT_HARD_LIMIT_ENABLE
#undef DEFAULT_HARD_LIMIT_ENABLE
#define DEFAULT_HARD_LIMIT_ENABLE 1
#else
#define DEFAULT_HARD_LIMIT_ENABLE 0
#endif

#ifdef DEFAULT_INVERT_PROBE_BIT
#undef DEFAULT_INVERT_PROBE_BIT
#define DEFAULT_INVERT_PROBE_BIT 1
#else
#define DEFAULT_INVERT_PROBE_BIT 0
#endif

#ifndef DEFAULT_A_STEPS_PER_MM
#define DEFAULT_A_STEPS_PER_MM 250.0f
#endif
#ifndef DEFAULT_A_MAX_RATE
#define DEFAULT_A_MAX_RATE 500.0f
#endif
#ifndef DEFAULT_A_ACCELERATION
#define DEFAULT_A_ACCELERATION DEFAULT_ACCELERATION
#endif
#ifndef DEFAULT_A_MAX_TRAVEL
#define DEFAULT_A_MAX_TRAVEL 200.0f
#endif

#ifndef DEFAULT_B_STEPS_PER_MM
#define DEFAULT_B_STEPS_PER_MM 250.0f
#endif
#ifndef DEFAULT_B_MAX_RATE
#define DEFAULT_B_MAX_RATE 500.0f
#endif
#ifndef DEFAULT_B_ACCELERATION
#define DEFAULT_B_ACCELERATION DEFAULT_ACCELERATION
#endif
#ifndef DEFAULT_B_MAX_TRAVEL
#define DEFAULT_B_MAX_TRAVEL 200.0f
#endif

#ifndef DEFAULT_C_STEPS_PER_MM
#define DEFAULT_C_STEPS_PER_MM 250.0f
#endif
#ifndef DEFAULT_C_MAX_RATE
#define DEFAULT_C_MAX_RATE 500.0f
#endif
#ifndef DEFAULT_C_ACCELERATION
#define DEFAULT_C_ACCELERATION DEFAULT_ACCELERATION
#endif
#ifndef DEFAULT_C_MAX_TRAVEL
#define DEFAULT_C_MAX_TRAVEL 200.0f
#endif

#ifndef DEFAULT_U_STEPS_PER_MM
#define DEFAULT_U_STEPS_PER_MM 250.0f
#endif
#ifndef DEFAULT_U_MAX_RATE
#define DEFAULT_U_MAX_RATE 500.0f
#endif
#ifndef DEFAULT_U_ACCELERATION
#define DEFAULT_U_ACCELERATION DEFAULT_ACCELERATION
#endif
#ifndef DEFAULT_U_MAX_TRAVEL
#define DEFAULT_U_MAX_TRAVEL 200.0f
#endif

#ifndef DEFAULT_V_STEPS_PER_MM
#define DEFAULT_V_STEPS_PER_MM 250.0f
#endif
#ifndef DEFAULT_V_MAX_RATE
#define DEFAULT_V_MAX_RATE 500.0f
#endif
#ifndef DEFAULT_V_ACCELERATION
#define DEFAULT_V_ACCELERATION DEFAULT_ACCELERATION
#endif
#ifndef DEFAULT_V_MAX_TRAVEL
#define DEFAULT_V_MAX_TRAVEL 200.0f
#endif

#ifndef DEFAULT_G73_RETRACT
#define DEFAULT_G73_RETRACT 0.1f
#endif

#ifdef DEFAULT_LASER_MODE
#undef DEFAULT_LASER_MODE
#define DEFAULT_LASER_MODE 1
#else
#define DEFAULT_LASER_MODE 0
#endif

#ifdef DEFAULT_LATHE_MODE
#undef DEFAULT_LATHE_MODE
#define DEFAULT_LATHE_MODE 1
#else
#define DEFAULT_LATHE_MODE 0
#endif

#if DEFAULT_LASER_MODE && DEFAULT_LATHE_MODE
#error "Cannot enable laser and lathe mode at the same time!"
#endif

#ifndef DEFAULT_SPINDLE_PPR
#define DEFAULT_SPINDLE_PPR 0.
#endif

#ifndef DEFAULT_SPINDLE_P_GAIN
#define DEFAULT_SPINDLE_P_GAIN  1.0f
#endif
#ifndef DEFAULT_SPINDLE_I_GAIN
#define DEFAULT_SPINDLE_I_GAIN  0.01f
#endif
#ifndef DEFAULT_SPINDLE_D_GAIN
#define DEFAULT_SPINDLE_D_GAIN  0.0f
#endif
#ifndef DEFAULT_SPINDLE_I_MAX
#define DEFAULT_SPINDLE_I_MAX   10.0f
#endif

#ifdef DEFAULT_SLEEP_ENABLE
#undef DEFAULT_SLEEP_ENABLE
#define DEFAULT_SLEEP_ENABLE 1
#else
#define DEFAULT_SLEEP_ENABLE 0
#endif

#ifdef DEFAULT_ENABLE_LASER_DURING_HOLD
#undef DEFAULT_ENABLE_LASER_DURING_HOLD
#define DEFAULT_ENABLE_LASER_DURING_HOLD 0
#else
#define DEFAULT_ENABLE_LASER_DURING_HOLD 1
#endif


#ifdef DEFAULT_LIMITS_TWO_SWITCHES_ON_AXES
#undef DEFAULT_LIMITS_TWO_SWITCHES_ON_AXES
#define DEFAULT_LIMITS_TWO_SWITCHES_ON_AXES 1
#else
#define DEFAULT_LIMITS_TWO_SWITCHES_ON_AXES 0
#endif

#ifdef DEFAULT_NO_RESTORE_AFTER_FEED_HOLD
#define DEFAULT_RESTORE_AFTER_FEED_HOLD 0
#undef DEFAULT_NO_RESTORE_AFTER_FEED_HOLD
#else
#define DEFAULT_RESTORE_AFTER_FEED_HOLD 1
#endif

#ifdef DEFAULT_FORCE_INITIALIZATION_ALARM
#undef DEFAULT_FORCE_INITIALIZATION_ALARM
#define DEFAULT_FORCE_INITIALIZATION_ALARM 1
#else
#define DEFAULT_FORCE_INITIALIZATION_ALARM 0
#endif

#ifdef DEFAULT_CHECK_LIMITS_AT_INIT
#undef DEFAULT_CHECK_LIMITS_AT_INIT
#define DEFAULT_CHECK_LIMITS_AT_INIT 1
#else
#define DEFAULT_CHECK_LIMITS_AT_INIT 0
#endif

#ifdef DEFAULT_HOMING_INIT_LOCK
#undef DEFAULT_HOMING_INIT_LOCK
#define DEFAULT_HOMING_INIT_LOCK 1
#else
#define DEFAULT_HOMING_INIT_LOCK 0
#endif

#ifdef HOMING_SINGLE_AXIS_COMMANDS
#undef HOMING_SINGLE_AXIS_COMMANDS
#define HOMING_SINGLE_AXIS_COMMANDS 1
#else
#define HOMING_SINGLE_AXIS_COMMANDS 0
#endif

#ifdef HOMING_FORCE_SET_ORIGIN
#undef HOMING_FORCE_SET_ORIGIN
#define HOMING_FORCE_SET_ORIGIN 1
#else
#define HOMING_FORCE_SET_ORIGIN 0
#endif

#ifdef DEFAULT_HOMING_OVERRIDE_LOCKS
#undef DEFAULT_HOMING_OVERRIDE_LOCKS
#define DEFAULT_HOMING_OVERRIDE_LOCKS 1
#else
#define DEFAULT_HOMING_OVERRIDE_LOCKS 0
#endif

#ifndef DUAL_AXIS_HOMING_FAIL_AXIS_LENGTH_PERCENT
#define DUAL_AXIS_HOMING_FAIL_AXIS_LENGTH_PERCENT  5.0f
#endif
#ifndef DUAL_AXIS_HOMING_FAIL_DISTANCE_MAX
#define DUAL_AXIS_HOMING_FAIL_DISTANCE_MAX  25.0f  // Float (mm)
#endif
#ifndef DUAL_AXIS_HOMING_FAIL_DISTANCE_MIN
#define DUAL_AXIS_HOMING_FAIL_DISTANCE_MIN  2.5f // Float (mm)
#endif

#ifdef DEFAULT_PARKING_ENABLE
#undef DEFAULT_PARKING_ENABLE
#define DEFAULT_PARKING_ENABLE 1
#else
#define DEFAULT_PARKING_ENABLE 0
#endif

#ifndef DEFAULT_PARKING_AXIS
#define DEFAULT_PARKING_AXIS Z_AXIS
#endif
#ifndef DEFAULT_PARKING_TARGET
#define DEFAULT_PARKING_TARGET -5.0f
#endif
#ifndef DEFAULT_PARKING_RATE
#define DEFAULT_PARKING_RATE 500.0f
#endif
#ifndef DEFAULT_PARKING_PULLOUT_RATE
#define DEFAULT_PARKING_PULLOUT_RATE 100.0f
#endif
#ifndef DEFAULT_PARKING_PULLOUT_INCREMENT
#define DEFAULT_PARKING_PULLOUT_INCREMENT 5.0f
#endif

#ifdef DEFAULT_ENABLE_PARKING_OVERRIDE_CONTROL
#undef DEFAULT_ENABLE_PARKING_OVERRIDE_CONTROL
#define DEFAULT_ENABLE_PARKING_OVERRIDE_CONTROL 1
#else
#define DEFAULT_ENABLE_PARKING_OVERRIDE_CONTROL 0
#endif

#ifdef DEFAULT_DEACTIVATE_PARKING_UPON_INIT
#undef DEFAULT_DEACTIVATE_PARKING_UPON_INIT
#define DEFAULT_DEACTIVATE_PARKING_UPON_INIT 1
#else
#define DEFAULT_DEACTIVATE_PARKING_UPON_INIT 0
#endif

#ifdef ALLOW_FEED_OVERRIDE_DURING_PROBE_CYCLES
#undef ALLOW_FEED_OVERRIDE_DURING_PROBE_CYCLES
#define ALLOW_FEED_OVERRIDE_DURING_PROBE_CYCLES 1
#else
#define ALLOW_FEED_OVERRIDE_DURING_PROBE_CYCLES 0
#endif

#ifdef DEFAULT_NO_LEGACY_RTCOMMANDS
#undef DEFAULT_NO_LEGACY_RTCOMMANDS
#define DEFAULT_LEGACY_RTCOMMANDS 0
#else
#define DEFAULT_LEGACY_RTCOMMANDS 1
#endif

#ifndef DEFAULT_TOOLCHANGE_MODE
#define DEFAULT_TOOLCHANGE_MODE 0
#endif
#ifndef DEFAULT_TOOLCHANGE_PROBING_DISTANCE
#define DEFAULT_TOOLCHANGE_PROBING_DISTANCE 30
#endif
#ifndef DEFAULT_TOOLCHANGE_FEED_RATE
#define DEFAULT_TOOLCHANGE_FEED_RATE 25.0f
#endif
#ifndef DEFAULT_TOOLCHANGE_SEEK_RATE
#define DEFAULT_TOOLCHANGE_SEEK_RATE 200.0f
#endif
#ifndef DEFAULT_TOOLCHANGE_PULLOFF_RATE
#define DEFAULT_TOOLCHANGE_PULLOFF_RATE 100.0f
#endif

#ifdef DEFAULT_HOMING_ENABLE
#undef DEFAULT_HOMING_ENABLE
#define DEFAULT_HOMING_ENABLE 1
#else
#define DEFAULT_HOMING_ENABLE 0
#endif

#ifdef DEFAULT_HOMING_ALLOW_MANUAL
#undef DEFAULT_HOMING_ALLOW_MANUAL
#define DEFAULT_HOMING_ALLOW_MANUAL 1
#else
#define DEFAULT_HOMING_ALLOW_MANUAL 0
#endif

#ifndef DEFAULT_HOMING_DIR_MASK
#define DEFAULT_HOMING_DIR_MASK 0
#endif
#ifndef DEFAULT_HOMING_FEED_RATE
#define DEFAULT_HOMING_FEED_RATE 25.0f
#endif
#ifndef DEFAULT_HOMING_SEEK_RATE
#define DEFAULT_HOMING_SEEK_RATE 500.0f
#endif
#ifndef DEFAULT_HOMING_DEBOUNCE_DELAY
#define DEFAULT_HOMING_DEBOUNCE_DELAY 250
#endif
#ifndef DEFAULT_HOMING_PULLOFF
#define DEFAULT_HOMING_PULLOFF 1.0f
#endif

#ifndef DEFAULT_N_HOMING_LOCATE_CYCLE
#define DEFAULT_N_HOMING_LOCATE_CYCLE 1
#endif

#ifndef HOMING_CYCLE_0
#define HOMING_CYCLE_0 (Z_AXIS_BIT)
#endif
#ifndef HOMING_CYCLE_1
#define HOMING_CYCLE_1 (X_AXIS_BIT|Y_AXIS_BIT)
#endif
#ifndef HOMING_CYCLE_2
#define HOMING_CYCLE_2 0
#endif
#ifndef HOMING_CYCLE_3
#define HOMING_CYCLE_3 0
#endif
#ifndef HOMING_CYCLE_4
#define HOMING_CYCLE_4 0
#endif
#ifndef HOMING_CYCLE_5
#define HOMING_CYCLE_5 0
#endif

#ifndef ST_DEENERGIZE_MASK
#define ST_DEENERGIZE_MASK 0
#endif

#ifndef ST_ROTATIONAL_MASK
#define ST_ROTATIONAL_MASK 0
#endif

#ifndef INVERT_ST_ENABLE_MASK
#define INVERT_ST_ENABLE_MASK AXES_BITMASK
#endif

#ifndef INVERT_LIMIT_BIT_MASK
#define INVERT_LIMIT_BIT_MASK 0
#endif

#ifndef INVERT_CONTROL_PIN_MASK
#define INVERT_CONTROL_PIN_MASK 0
#endif

#ifndef INVERT_SPINDLE_ENABLE_PIN
#define INVERT_SPINDLE_ENABLE_PIN 0
#endif

#ifndef INVERT_SPINDLE_CCW_PIN
#define INVERT_SPINDLE_CCW_PIN 0
#endif

#ifndef INVERT_SPINDLE_PWM_PIN
#define INVERT_SPINDLE_PWM_PIN 0
#endif

#ifndef DISABLE_LIMIT_BITS_PULL_UP_MASK
#define DISABLE_LIMIT_BITS_PULL_UP_MASK 0
#endif

#ifndef DISABLE_PROBE_BIT_PULL_UP
#define DISABLE_PROBE_BIT_PULL_UP 0
#endif

#ifndef DISABLE_CONTROL_PINS_PULL_UP_MASK
#define DISABLE_CONTROL_PINS_PULL_UP_MASK 0
#endif

#ifndef ALLOW_FEED_OVERRIDE_DURING_PROBE_CYCLES
#define ALLOW_FEED_OVERRIDE_DURING_PROBE_CYCLES 0
#endif

#ifndef INVERT_COOLANT_FLOOD_PIN
#define INVERT_COOLANT_FLOOD_PIN 0
#endif

#ifndef INVERT_COOLANT_MIST_PIN
#define INVERT_COOLANT_MIST_PIN 0
#endif

#ifndef NGC_EXPRESSIONS_ENABLE
#define NGC_EXPRESSIONS_ENABLE 0
#else
#define NGC_N_ASSIGN_PARAMETERS_PER_BLOCK 10
#endif

// ---------------------------------------------------------------------------------------
// COMPILE-TIME ERROR CHECKING OF DEFINE VALUES:

#if DEFAULT_PARKING_ENABLE > 0
  #if DEFAULT_HOMING_FORCE_SET_ORIGIN > 0
    #error "HOMING_FORCE_SET_ORIGIN is not supported with PARKING_ENABLE at this time."
  #endif
#endif

#if DEFAULT_ENABLE_PARKING_OVERRIDE_CONTROL > 0
  #if DEFAULT_PARKING_ENABLE < 1
    #error "ENABLE_PARKING_OVERRIDE_CONTROL must be enabled with PARKING_ENABLE."
  #endif
#endif

// ---------------------------------------------------------------------------------------

#endif
